<?php
session_start();
require '../conexao.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador_atual = $_SESSION['user_name'];
$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $jogador_destino = trim($_POST['jogador_destino']);
    $quantidade = (int)$_POST['quantidade'];
    $pin = $_POST['pin'];
    
    if (empty($jogador_destino) || $quantidade <= 0 || empty($pin)) {
        $_SESSION['msg'] = "Preencha todos os campos corretamente!";
        header("Location: transferir_fichas.php");
        exit();
    }

    if (!password_verify($pin, $_SESSION['user_pin'])) {
        $_SESSION['msg'] = "PIN incorreto!";
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $stmt = $pdo->prepare("SELECT user FROM usersblock WHERE user = ?");
        $stmt->execute([$jogador_destino]);
        if ($stmt->rowCount() === 0) {
            $_SESSION['msg'] = "Jogador destino não encontrado!";
            header("Location: transferir_fichas.php");
            exit();
        }
    } catch (PDOException $e) {
        $_SESSION['msg'] = "Erro ao verificar jogador: " . $e->getMessage();
        header("Location: transferir_fichas.php");
        exit();
    }

    try {
        $pdo->beginTransaction();

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$jogador_atual]);
        $fichas_disponiveis = $stmt->fetchColumn();

        if ($fichas_disponiveis < $quantidade) {
            $pdo->rollBack();
            $_SESSION['msg'] = "Você só tem $fichas_disponiveis fichas disponíveis!";
            header("Location: transferir_fichas.php");
            exit();
        }

        // Usa diretamente o valor de $quantidade no SQL
        $limite = intval($quantidade);
        $sql_transferencia = "UPDATE fichaspersonagens 
                              SET jogador = ? 
                              WHERE jogador = ? AND situacao = '1' 
                              LIMIT $limite";
        $stmt = $pdo->prepare($sql_transferencia);
        $stmt->execute([$jogador_destino, $jogador_atual]);

        $stmt = $pdo->query("SELECT MAX(chave) FROM transferencias");
        $ultima_chave = $stmt->fetchColumn();
        $nova_chave = $ultima_chave ? $ultima_chave + 1 : 1;

        $stmt = $pdo->prepare("SELECT COUNT(*) FROM transferencias WHERE chave = ?");
        $stmt->execute([$nova_chave]);
        if ($stmt->fetchColumn() > 0) {
            $nova_chave = $pdo->query("SELECT MAX(chave)+1 FROM transferencias")->fetchColumn();
        }

        $info_transferencia = "$quantidade fichas transferidas";

        $sql_insert = "INSERT INTO transferencias 
                      (tipo, transferiu, recebeu, informacoes, chave, val) 
                      VALUES 
                      ('ficha', ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql_insert);
        $stmt->execute([$jogador_atual, $jogador_destino, $info_transferencia, $nova_chave]);

        $info_sistema = "O usuário $jogador_atual transferiu $quantidade fichas para $jogador_destino";
        $sql_info = "INSERT INTO infossistema (informacao, p1, origem, dataehora) 
                    VALUES (?, ?, 'transferencia', NOW())";
        $stmt = $pdo->prepare($sql_info);
        $stmt->execute([$info_sistema, $jogador_atual]);

        $pdo->commit();

        $_SESSION['msg'] = "Transferência de $quantidade fichas para $jogador_destino realizada com sucesso!";
        header("Location: transferir_fichas.php");
        exit();

    } catch (PDOException $e) {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro na transferência: " . $e->getMessage();
        header("Location: transferir_fichas.php");
        exit();
    }
}

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
    $stmt->execute([$jogador_atual]);
    $total_fichas = $stmt->fetchColumn();
} catch (PDOException $e) {
    $total_fichas = 0;
    $_SESSION['msg'] = "Erro ao consultar fichas: " . $e->getMessage();
}
?>


<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Transferência de Fichas</title>
    <style>
        body {
            background-color: #121212;
            font-family: Arial, sans-serif;
            color: #e0e0e0;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            background: #1e1e1e;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px #000;
            margin: auto;
        }

        h1 {
            text-align: center;
            color: #00aaff;
            margin-bottom: 30px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #cccccc;
        }

        input {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            background-color: #2c2c2c;
            border: 1px solid #444;
            color: #fff;
            border-radius: 5px;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background-color: #007bff;
            border: none;
            color: white;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
        }

        .btn:hover {
            background-color: #0056b3;
        }

        .mensagem {
            background-color: #333;
            border-left: 5px solid #007bff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .fichas-count {
            font-size: 1.5rem;
            text-align: center;
            color: #00aaff;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Transferência de Fichas</h1>

        <?php if (isset($_SESSION['msg'])): ?>
            <div class="mensagem"><?= $_SESSION['msg']; unset($_SESSION['msg']); ?></div>
        <?php endif; ?>

        <div class="fichas-count">Fichas disponíveis: <?= $total_fichas ?></div>

        <form method="POST">
            <label for="jogador_destino">Nome do Jogador Destino:</label>
            <input type="text" id="jogador_destino" name="jogador_destino" required>

            <label for="quantidade">Quantidade de Fichas:</label>
            <input type="number" id="quantidade" name="quantidade" min="1" max="<?= $total_fichas ?>" required>

            <label for="pin">Código PIN:</label>
            <input type="password" id="pin" name="pin" maxlength="4" required>

            <button type="submit" class="btn">Realizar Transferência</button>
        </form>
    </div>
</body>
</html>
